
package AOMCase;

import com.metamaxim.modelscope.callbacks.*;

public class MakeRecommendations extends Event {

  public void handleEvent() {

	  //Use the "Needed Mission" objects for this Crisis Type to determine the types of Internal Mission that are required
	  //Create recommended Internal Missions for each needed type
	  Instance myType = this.getInstance("Crisis").getInstance("Crisis Type");
	  String crisisName = this.getInstance("Crisis").getString("Crisis Name");
	  Instance[] myNeededInternalMissions = myType.selectByRef("Needed Mission", "Crisis Type");
	  int i = 0; int j = 0;
	  for (i = 0; i < myNeededInternalMissions.length; i++) {
		  j++;
		  Event internalMissionRecommendation = this.createEvent("Recommend Internal Mission");
		  internalMissionRecommendation.setString("Internal Mission Name", crisisName + " Internal Mission " + Integer.toString(j));
		  internalMissionRecommendation.setNewInstance("Internal Mission", "Internal Mission");
		  internalMissionRecommendation.setInstance("Mission Type", myNeededInternalMissions[i].getInstance("Needs"));
		  internalMissionRecommendation.submitToModel();
	  	  }
	  //Use the "Needed External Mission" objects for this Crisis Type to determine the types of External Mission that are required
	  //Create recommended External Missions for each needed type
	  Instance[] myNeededExternalMissions = myType.selectByRef("Needed External Mission", "Crisis Type");
	  for (i = 0; i < myNeededExternalMissions.length; i++) {
		  j++;
		  Event externalMissionRecommendation = this.createEvent("Recommend External Mission");
		  externalMissionRecommendation.setString("External Mission Name", crisisName + " External Mission " + Integer.toString(j));
		  externalMissionRecommendation.setNewInstance("External Mission", "External Mission");
		  externalMissionRecommendation.setInstance("External Resource System", myNeededExternalMissions[i].getInstance("Needs"));
		  externalMissionRecommendation.submitToModel();
	  	  }
	  //Send the trigger to the model to update the state of the Crisis to say that recommended Missions have been created
	  this.submitToModel();
	}

}


